*! eq5dmap: a command for mapping between EQ-5D-3L and EQ-5D-5L
*! Please ref: Hernandez Alava, M., Pudney, S., and Wailoo, A. (2020) Estimating the relationship between EQ-5D-5L and EQ-5D-3L: results from an English 
*! Population Study. Policy Research Unit in Economic Evaluation of Health and Care Interventions. Universities of Sheffield and York. Report 063 
*! Example do file
*! Authors: Monica Hernandez Alava and Steve Pudney
*============================================================*

clear all
set more off
set type double

//Change to your working directory
cd "G:\My Drive\Allan Wailoo\DSU\2021 Projects\TSD10 update\Mapping 5L to 3L training"

//===============================================
//  Load the input dataset or input your own data
// 3 with items, 3 with scores
//Either integer age, or age-band (1 = <35, 2 = [35, 45), 3 = [45, 55), 4 = [55, 65), 5 = [65 to 100)
//Age gender  Y5_1    Y5_2    Y5_3    Y5_4    Y5_5  predicted 3L score  
// 30	0		1		2		3		4		5	0.067187178
// 50	0		2		4		1		1		2	0.760650031
// 5	1		2		3		4		2		1	0.608854632  - age group 5 = [65 to 100)

//Age gender   5L score  predicted 3L score
//50	1		0.715		0.84667987
//30	0		0.435		0.452101952
//70	1		0.95		0.84404896


import excel "eq5dmapUK - data.xlsx", sheet("Sheet1") firstrow

// for help with the command type in the command window
// help eq5dmap


//=========================
// mapping from items 
//=========================


//exact age - multiple domain scores

eq5dmap E_Y3age in 1/2, cov(age male) items(Y5_1 Y5_2 Y5_3 Y5_4 Y5_5) 

list age male Y5_1-Y5_5 E_Y3age in 1/2

// age-band - single score

eq5dmap E_Y3gagex in 3, cov(age male) items(Y5_1 Y5_2 Y5_3 Y5_4 Y5_5) 

//=============================
// mapping from utility score 
//=============================

// mapping from exact 5L utility scores - multiple scores

eq5dmap E_Y3exact5L in 4/5, cov(age male) score(util5L) 

list age male util5L E_Y3exact5L in 4/5



// mapping from mean 5L utility scores - use of bandwidth

eq5dmap E_Y3mean5L in 6, cov(age male) score(util5L)  bw(0.1)




